var $madcap_ERROBJ = new Object;
var $madcap_VERBOSE = 0;





  var $madcap_dayMlSc = 86400000;
  var $madcap_hourMlSc = 3600000;


  var $madcap_sesCkHours = .5;


  var $madcap_cpSzErrLvl = 40;
  var $madcap_cpSzWrnLvl = 20;


  var $madcap_ckSzErrLvl = 2000;
  var $madcap_ckSzWrnLvl = 1000;



function MadCap ($cpId,$cpPerTyp,$cpPer,$cap,$svrDt,$errRptLvl,$errBaseUrl,$errAsset,$verbose){


  if (window.CNET_FULL_FREQCAP != null &&
      (window.CNET_FULL_FREQCAP == 'YES' || window.CNET_FULL_FREQCAP == 'yes')) {
      return;
  }


  $madcap_ERROBJ.rptLvl = $errRptLvl;
  $madcap_ERROBJ.baseUrl = $errBaseUrl;
  $madcap_ERROBJ.asset = $errAsset;
  $madcap_VERBOSE = $verbose;


  if ($madcap_ERROBJ.rptLvl >= 2) error("Begin:+"+getCookieVals());


  if (!($cpId && $cpPerTyp && $cap)) {
    error("bad+input:+capId="+$cpId+",capPerType="+$cpPerTyp+",cap="+$cap);
  }
  else {
    if ($cpPerTyp == 'ses') {
      processMADCAPSCookie($cpId,$cap);
    }
    else if (($cpPerTyp == 'eol') || ($cpPerTyp == 'day')) {
      processMADCAPPCookie($cpId,$cpPerTyp,$cpPer,$cap,$svrDt);
    }
    else {
      error("unsupported+period+type:+capPerType="+$cpPerTyp);
    }
  }


  if ($madcap_ERROBJ.rptLvl >= 2) error("End:+"+getCookieVals());
}



function processMADCAPSCookie($cpId,$cap) {
  var $fmtId = 1;
  var nwCpArr = new Array;
  var ckFound = 0;
  var idFound = 0;
  var ckStr = getCookieValue("MADCAPS");
  if ($madcap_VERBOSE)
 document.write("<br/>CURRENT COOKIE STRING: '"+ckStr+"'<br/>\n");
  if (ckStr){
    ckFound = 1;

    var ckFmtId = baseUnConvert(ckStr.substr(0,1));
    ckStr = ckStr.substr(1);

    if (ckFmtId != $fmtId) {
      error("unsupported+MADCAPS+cookie+formatId:+"+$ckFmtId);
    }
    else {


      var cpArr = ckStr.split("&");


      for (i = 0; i < cpArr.length; i++){

 var thisCap = getIdAndCap(cpArr[i]);






 if (thisCap.id == $cpId){
   idFound = 1;
   thisCap.cap--;
   if (thisCap.cap < 0) {
     error("capId+"+thisCap.id+"+has+a+cap+below+0:+"+thisCap.cap);
   }
 }
 nwCpArr.push(thisCap);
      }
    }
  }

  if (!idFound) {
    var thisCap = new Object;
    thisCap.id = $cpId;
    thisCap.cap = $cap-1;

    nwCpArr = checkNumCaps(nwCpArr,thisCap,"MADCAPS");
  }


  var nwCpStr = "";
  for (i = 0; i < nwCpArr.length; i++){
    var cp = nwCpArr[i];
    if (i > 0) nwCpStr += "&";
    nwCpStr += getCapStr(cp);
    if ($madcap_VERBOSE)
 document.write("--cap#: ",i+1,", id: "+cp.id+", cap: "+cp.cap+"<br/>");
  }



  if (allowableCookieSize(nwCpStr,ckStr,"MADCAPS")) {

      var ckExp = new Date();
      ckExp = new Date(ckExp.getTime()+($madcap_sesCkHours*$madcap_hourMlSc));
      var ckVal = baseConvert($fmtId) + nwCpStr;
      madcap_setCookie("MADCAPS",ckVal,ckExp);
  }
}




function processMADCAPPCookie($cpId,$cpPerTyp,$cpPer,$cap,$svrDt) {
  if (!$svrDt || ($svrDt.split('.')[0]<2005)) {
    error("bad+input:+svrDt="+$svrDt);

    var now = new Date();
    $svrDt = now.getFullYear()+'.'+(now.getMonth()+1)+'.'+now.getDate()+'.'+
             now.getHours()+'.'+now.getMinutes()+'.'+now.getSeconds();
  }

  var $svrDtAr = $svrDt.split('.');
  var $sysDt = new Date($svrDtAr[0],$svrDtAr[1]-1,$svrDtAr[2]);
  var $bsDt = new Date($svrDtAr[0],0,1);

  $sysDt = new Date($sysDt.getTime()+($bsDt.getTimezoneOffset()-
          $sysDt.getTimezoneOffset())*60000);
  var $yrOS = $svrDtAr[0] - 2000;

  var $fmtId = 0;
  var nwCpArr = new Array;
  var idFound = 0;
  var ckStr = getCookieValue("MADCAPP");
  if ($madcap_VERBOSE) document.write("CURRENT COOKIE STRING: '"+ckStr+"'<br/>\n");
  if (ckStr){

    var ckFmtId = baseUnConvert(ckStr.substr(0,1));
    ckStr = ckStr.substr(1);

    if (ckFmtId != $fmtId) {
      error("found+unsupported+MADCAPP+cookie+formatId:+"+$ckFmtId);
    }
    else {



      var ckYrOS= new Date(2000 + baseUnConvert(ckStr.substr(0,1)),0,1);
      ckStr = ckStr.substr(1);


      var cpArr = ckStr.split("&");


      for (i = 0; i < cpArr.length; i++) {

 var thisCap = getIdAndCap(cpArr[i].substr(2));
 var dayOffset = baseUnConvert(cpArr[i].substr(0,2));


 thisCap.expDt = new Date(ckYrOS.getTime()+(dayOffset*$madcap_dayMlSc));




 if ($madcap_VERBOSE && (thisCap.expDt.getTime() < $sysDt.getTime()))
     document.write("cap expired: id: "+thisCap.id+", expDt: '"+
      thisCap.expDt+"'. removing this and all "+
      "subsequent caps<br>\n");
 if (thisCap.expDt.getTime() < $sysDt.getTime()) break;






 if (thisCap.id == $cpId){
   if ($madcap_VERBOSE) document.write("found THIS cap: id="+$cpId+"<br>\n");
   idFound = 1;
   thisCap.cap--;
   if (thisCap.cap < 0) {
     error("capId+"+thisCap.id+"+has+a+cap+below+0:+"+thisCap.cap);
   }
 }
 nwCpArr.push(thisCap);
      }
    }
  }





  if (!idFound) {
    var thisCap = new Object;
    thisCap.id = $cpId;
    thisCap.cap = $cap - 1;
    if ($cpPerTyp == 'eol'){
      var dtArr = $cpPer.split('.');
      var expDt = new Date(dtArr[0],dtArr[1]-1,dtArr[2]);

      thisCap.expDt = new Date(expDt.getTime()+($bsDt.getTimezoneOffset()-
          expDt.getTimezoneOffset())*60000);
    }
    else {
      thisCap.expDt =
 new Date($sysDt.getTime()+(($cpPer-1)*$madcap_dayMlSc));
    }


    if (thisCap.expDt.getTime() >= $sysDt.getTime()) {

      nwCpArr = checkNumCaps(nwCpArr,thisCap,"MADCAPP");
    }
  }


  nwCpArr.sort(function(a,b){return b.expDt-a.expDt;});


  var nwCpStr = "";
  for (i = 0; i < nwCpArr.length; i++){
    var cp = nwCpArr[i];
    if (i > 0) nwCpStr += "&";
    nwCpStr += getCapStr(cp,$bsDt);
    if ($madcap_VERBOSE) document.write("--cap#: ",i+1,", id: "+cp.id+", cap: "+
     cp.cap+", expDt: '"+cp.expDt+"'<br/>");
  }



  if (allowableCookieSize(nwCpStr,ckStr,"MADCAPP")) {

    var ckExp = new Date();
    ckExp.setYear(ckExp.getFullYear() + 1);
    var ckVal = baseConvert($fmtId) + baseConvert($yrOS) + nwCpStr;
    madcap_setCookie("MADCAPP",ckVal,ckExp);
  }
}




function getCapStr(cp,$bsDt) {
  var cpStr = "";
  if ($bsDt) {


    var expDt = baseConvert((cp.expDt.getTime() - $bsDt.getTime()) / $madcap_dayMlSc);

    if (expDt.length == 1) cpStr += '0';
    cpStr += expDt;
  }


  cpStr += baseConvert(cp.id);


  if (cp.cap > 0) cpStr += "="+ baseConvert(cp.cap);

  else if (cp.cap < 0) cpStr += ":"+ baseConvert(-(cp.cap));


  return cpStr;
}


function getIdAndCap(ck) {
  var cap = new Object;
  var delim;

  if ((delim = ck.indexOf("=")) > 0){

    cap.id = ck.substr(0,delim);
    cap.cap = baseUnConvert(ck.substr(delim + 1));
  }
  else if ((delim = ck.indexOf(":")) > 0){

    cap.id = ck.substr(0,delim);
    cap.cap = -(baseUnConvert(ck.substr(delim + 1)));
  }
  else {

    cap.id = ck;
    cap.cap = 0;
  }
  cap.id = baseUnConvert(cap.id);
  return(cap);
}



function getCookieValue(ckNm){
  var value = null;
  allCookies = document.cookie;
  var pos = allCookies.indexOf(ckNm);
  if (pos != -1) {
    var start = pos + ckNm.length + 1;
    var end = allCookies.indexOf(";",start);
    if (end==-1) end = allCookies.length;
    value = allCookies.substring(start,end);
  }
  return value ? value : null;
}


function madcap_setCookie(nm,vl,expDt) {
    var dm = document.domain.split('.');

    var ckAttr = new Array(nm+'='+vl,'path=/','domain=.'+dm[dm.length-2]+
    '.'+dm[dm.length-1]);
    if (expDt) ckAttr.push('expires='+expDt.toGMTString());
    document.cookie = ckAttr.join(";");
    if ($madcap_VERBOSE) document.write ("Final Cookie string: '",ckAttr.join(";"),
      "'<br/>\n");
}



function checkNumCaps(cpArr,cap,cpName) {
  if (cpArr.length >= $madcap_cpSzErrLvl) {
    error(cpName+":+reached+max+number+of+caps+("+cpArr.length+"+>=+"+
   $madcap_cpSzErrLvl+")+NOT+"+"adding+new+capId:+"+cap.id);
  }
  else {
    cpArr.push(cap);
    if (cpArr.length > $madcap_cpSzWrnLvl)
      error(cpName+":+exceeded+warning+number+of+caps+("+
     cpArr.length+"+>+"+$madcap_cpSzWrnLvl+")");
    if ($madcap_VERBOSE) document.write("adding new cap: id: "+cap.id+", cap: ",
     cap.cap-1," ,expDt: '"+cap.expDt+"'<br>\n");
  }

  return cpArr;
}




function allowableCookieSize(nwCkStr,oldCkStr,ckName) {

  if (nwCkStr.length > $madcap_ckSzErrLvl) {
    error(ckName+":+cookie+exceeded+max+length+("+nwCkStr.length+"+>+"+
   $madcap_ckSzErrLvl+").++NOT+setting+new+cookie");
    return 0;
  }
  else {

    oldCkStr = (oldCkStr==null)?"":oldCkStr;
    if ((nwCkStr.length > $madcap_ckSzWrnLvl) && (nwCkStr.length > oldCkStr.length)) {
      error(ckName+":+cookie+exceeding+warning+length+("+
     nwCkStr.length+"+>+"+$madcap_ckSzWrnLvl+")");
    }
    return 1;
  }
}

function getCookieVals() {
  var mp = getCookieValue("MADCAPP");
  mp = mp?mp.substr(0,50):"";
  var ms = getCookieValue("MADCAPS");
  ms = ms?ms.substr(0,50):"";
  return "MADCAPP="+mp+"+MADCAPS="+ms;
}


var MAPSTR ="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
function baseConvert(num) {
  var mod;
  var convNum = '';
  while (num >= MAPSTR.length){
    mod = num % MAPSTR.length;
    convNum = MAPSTR.charAt(mod) + convNum;
    num = Math.floor(num / MAPSTR.length);
  }
  convNum = MAPSTR.charAt(num) + convNum;
  return convNum;
}

function baseUnConvert(convNum) {
  var num = 0;
  for (var i=convNum.length-1;i>=0;i--){
    num += (Math.pow(MAPSTR.length,i) *
     MAPSTR.indexOf(convNum.charAt(convNum.length-1-i)));
  }
  return num;
}

function error($errMsg) {
  if (($madcap_ERROBJ.rptLvl >= 1) && ($madcap_ERROBJ.baseUrl)) {
    pic1= new Image(1,1);
    pic1.src= $madcap_ERROBJ.baseUrl + "MADCAP-ERROR:+"+$errMsg + "/" + $madcap_ERROBJ.asset;
    if ($madcap_VERBOSE) document.write("error call = "+pic1.src+"<br>\n");
  }
}
